﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Gemini.Core.BL.Base;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private APIEduFarmaType _api = null;
        /// <summary>
        /// API do synchronizacji z EduFarma
        /// </summary>
        public APIEduFarmaType APIEduFarma
        {
            get
            {
                if (_api == null)
                {
                    _api = new APIEduFarmaType(this);
                }
                return _api;
            }
        }
        /// <summary>
        /// klasa narzedziowa do API EduFarmy
        /// </summary>
        public class APIEduFarmaType
        {
            private ZSBELearning _plugIn = null;
            public APIEduFarmaType(ZSBELearning PlugIn)
            {
                _plugIn = PlugIn;
                _request = new API.GRequest(_plugIn);
            }

            private API.GRequest _request = null;

            #region Student
            /// <summary>
            /// Dodanie studenta po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncStudentAdd(BO.Student Student)
            {
                return Sync<API.Model.GStudent>(GetAPIStudent(Student), API.Model.MethodCodeType.Add);
            }

            /// <summary>
            /// Aktualizuje studenta po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncStudentUpdate(BO.Student Student)
            {
                return Sync<API.Model.GStudent>(GetAPIStudent(Student), API.Model.MethodCodeType.Update);
            }

            /// <summary>
            /// Usuwa studenta po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncStudentDelete(BO.Student Student)
            {
                return Sync<API.Model.GStudent>(GetAPIStudent(Student), API.Model.MethodCodeType.Delete);
            }

            /// <summary>
            /// Dodaje lub aktualizuje studenta po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncStudentSave(BO.Student Student)
            {
                return Sync<API.Model.GStudent>(GetAPIStudent(Student), API.Model.MethodCodeType.Save);
            }

            /// <summary>
            /// Pobiera studenta po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public BO.Student SyncStudentGet(long? ID, out MethodResult MethodResult)
            {
                API.Model.GStudent _student = Get<API.Model.GStudent>(ID, out MethodResult);
                if (_student != null)
                {
                    if (MethodResult == null || MethodResult.Success)
                    {
                        BO.Student _studentBO = _plugIn.Student.New();
                        _studentBO.Assign(_student);
                        // tutaj czytanie ID poprzez UserBID
                        PI.FM.N001.Account.BL.BO.User _user = _plugIn.RBL.Account.User.RestoreByID(_studentBO.UserID);
                        if (_user != null)
                        {
                            BL.BO.Student _studentUser = _plugIn.Student.Restore(_user);
                            if (_studentUser != null)
                            {
                                _studentBO.ID = _studentUser.ID;
                            }
                        }
                        return _studentBO;
                    }
                }
                return null;
            }

            /// <summary>
            /// Konwertuje obiekt studenta na obiekt API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            private API.Model.GStudent GetAPIStudent(BO.Student Student)
            {
                return Student.GetApiObject();
            }
            #endregion

            #region Instructor
            /// <summary>
            /// Dodanie instruktora po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncInstructorAdd(BO.Instructor Instructor)
            {
                return Sync<API.Model.GTeacher>(GetAPIInstructor(Instructor), API.Model.MethodCodeType.Add);
            }

            /// <summary>
            /// Aktualizuje instruktora po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncInstructorUpdate(BO.Instructor Instructor)
            {
                return Sync<API.Model.GTeacher>(GetAPIInstructor(Instructor), API.Model.MethodCodeType.Update);
            }

            /// <summary>
            /// Usuwa instruktora po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncInstructorDelete(BO.Instructor Instructor)
            {
                return Sync<API.Model.GTeacher>(GetAPIInstructor(Instructor), API.Model.MethodCodeType.Delete);
            }

            /// <summary>
            /// Dodaje lub aktualizuje instruktora po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncInstructorSave(BO.Instructor Instructor)
            {
                return Sync<API.Model.GTeacher>(GetAPIInstructor(Instructor), API.Model.MethodCodeType.Save);
            }

            /// <summary>
            /// Pobiera instruktora po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public BO.Instructor SyncInstructorGet(long? ID, out MethodResult MethodResult)
            {
                API.Model.GTeacher _teacher = Get<API.Model.GTeacher>(ID, out MethodResult);
                if (_teacher != null)
                {
                    if (MethodResult == null || MethodResult.Success)
                    {
                        BO.Instructor _instructorBO = _plugIn.Instructor.New();
                        _instructorBO.Assign(_teacher);
                        // tutaj czytanie ID poprzez UserBID
                        PI.FM.N001.Account.BL.BO.User _user = _plugIn.RBL.Account.User.RestoreByID(_instructorBO.UserID);
                        if (_user != null)
                        {
                            BL.BO.Instructor _instructor = _plugIn.Instructor.Restore(_user);
                            if (_instructor != null)
                            {
                                _instructorBO.ID = _instructor.ID;
                            }
                        }
                        return _instructorBO;
                    }
                }

                return null;
            }

            /// <summary>
            /// Konwertuje obiekt instruktora na obiekt API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            private API.Model.GTeacher GetAPIInstructor(BO.Instructor Instructor)
            {
                return Instructor.GetApiObject();
            }
            #endregion

            #region Class
            /// <summary>
            /// Dodanie klasy po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncClassAdd(BO.Class Class)
            {
                return Sync<API.Model.GClass>(GetAPIClass(Class), API.Model.MethodCodeType.Add);
            }

            /// <summary>
            /// Aktualizuje klasy po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncClassUpdate(BO.Class Class)
            {
                return Sync<API.Model.GClass>(GetAPIClass(Class), API.Model.MethodCodeType.Update);
            }

            /// <summary>
            /// Usuwa klasy po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncClassDelete(BO.Class Class)
            {
                return Sync<API.Model.GClass>(GetAPIClass(Class), API.Model.MethodCodeType.Delete);
            }

            /// <summary>
            /// Dodaje lub aktualizuje klase po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncClassSave(BO.Class Class)
            {
                return Sync<API.Model.GClass>(GetAPIClass(Class), API.Model.MethodCodeType.Save);
            }

            /// <summary>
            /// Pobiera klasy po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public BO.Class SyncClassGet(long? ID, out MethodResult MethodResult)
            {
                API.Model.GClass _class = Get<API.Model.GClass>(ID, out MethodResult);
                if (_class != null)
                {
                    if (MethodResult == null || MethodResult.Success)
                    {
                        BO.Class _classBO = _plugIn.Class.New();
                        _classBO.Assign(_class);
                        // tutaj konwersja UserBID na InstructorID
                        PI.FM.N001.Account.BL.BO.User _user = _plugIn.RBL.Account.User.RestoreByID(_classBO.InstructorID);
                        if (_user != null)
                        {
                            BL.BO.Instructor _instructor = _plugIn.Instructor.Restore(_user);
                            if (_instructor != null)
                            {
                                _classBO.InstructorID = _instructor.ID;
                            }
                        }
                        return _classBO;
                    }
                }

                return null;
            }

            /// <summary>
            /// Konwertuje obiekt klasy na obiekt API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            private API.Model.GClass GetAPIClass(BO.Class Class)
            {
                API.Model.GClass _apiClass = Class.GetApiObject();
                // tutaj konwersja InstructorID na UserBID
                _apiClass.teacher_id = _plugIn.Instructor.Restore(long.Parse(_apiClass.teacher_id)).UserID.Value.ToString();
                return _apiClass;
            }
            #endregion

            #region School
            /// <summary>
            /// Dodanie szkoly po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncSchoolAdd(BO.School School)
            {
                return Sync<API.Model.GSchool>(GetAPISchool(School), API.Model.MethodCodeType.Add);
            }

            /// <summary>
            /// Aktualizuje szkoly po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncSchoolUpdate(BO.School School)
            {
                return Sync<API.Model.GSchool>(GetAPISchool(School), API.Model.MethodCodeType.Update);
            }

            /// <summary>
            /// Usuwa szkoly po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncSchoolDelete(BO.School School)
            {
                return Sync<API.Model.GSchool>(GetAPISchool(School), API.Model.MethodCodeType.Delete);
            }

            /// <summary>
            /// Dodaje lub aktualizuje szkole po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public MethodResult SyncSchoolSave(BO.School School)
            {
                return Sync<API.Model.GSchool>(GetAPISchool(School), API.Model.MethodCodeType.Save);
            }

            /// <summary>
            /// Pobiera szkoly po stronie API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            public BO.School SyncSchoolGet(long? ID, out MethodResult MethodResult)
            {
                API.Model.GSchool _GSchool = Get<API.Model.GSchool>(ID, out MethodResult);
                if (_GSchool != null)
                {
                    if (MethodResult == null || MethodResult.Success)
                    {
                        BO.School _SchoolBO = _plugIn.School.New();
                        _SchoolBO.Assign(_GSchool);
                        return _SchoolBO;
                    }
                }

                return null;
            }

            /// <summary>
            /// Konwertuje obiekt szkoly na obiekt API
            /// </summary>
            /// <param name="Student"></param>
            /// <returns></returns>
            private API.Model.GSchool GetAPISchool(BO.School School)
            {
                return School.GetApiObject();
            }
            #endregion

            #region Metody pomocnicze do API
            /// <summary>
            /// Komunikacja z serwerem API, przetwarzanie danych
            /// </summary>
            /// <typeparam name="T"></typeparam>
            /// <param name="InputObject"></param>
            /// <param name="MethodCode"></param>
            /// <returns></returns>
            private MethodResult Sync<T>(T InputObject, API.Model.MethodCodeType MethodCode)
                 where T : API.Model.GObject, new()
            {
                try
                {
                    API.GResponse<T> _response = _request.Process<T>(InputObject, MethodCode);
                    return ProcessResponse(_response);
                }
                catch (System.Exception except)
                {
                    return new MethodResult(except);
                }
            }

            /// <summary>
            /// Komunikacja z serwerem API, przetwarzanie danych dla metody Get
            /// </summary>
            /// <typeparam name="T"></typeparam>
            /// <param name="InputObject"></param>
            /// <param name="MethodCode"></param>
            /// <returns></returns>
            private T Get<T>(long? ID, out MethodResult MethodResult)
                 where T : API.Model.GObject, new()
            {
                MethodResult = null;
                try
                {
                    T _new = new T() { id = ID.ToString() };
                    API.GResponse<T> _response = _request.Process<T>(_new, API.Model.MethodCodeType.Get);
                    MethodResult = ProcessResponse(_response);
                    if (MethodResult.Success)
                    {
                        return _response.responseData;
                    }
                }
                catch (System.Exception except)
                {
                    MethodResult = new MethodResult(except);
                }
                return default(T);
            }

            /// <summary>
            /// Procesowanie odpowiedzi z serwera API
            /// </summary>
            /// <param name="Response"></param>
            /// <returns></returns>
            private MethodResult ProcessResponse(API.GResponseBase Response)
            {
                if (!string.IsNullOrEmpty(Response.InternalExceptionMessage))
                {
                    return new MethodResult(Response.InternalExceptionMessage, false);
                }

                if (Response.errorList != null && Response.errorList.Count > 0)
                {
                    MethodResult _result = new MethodResult(false);
                    foreach (API.Model.GError _loopGError in Response.errorList)
                    {
                        _result.Add(_loopGError.code.ToString(), false);
                    }
                    return _result;
                }

                return new MethodResult(true);
            }
            #endregion
        }

        /// <summary>
        /// Metoda synchronizujaca wszystkie obiekty poprzez API
        /// </summary>
        /// <param name="StartEventFunction">Funkcja ktora przyjmuje parametr INT - jako TotalCount ilosci obiektow do synchronizacji i zwraca TRUE/FALSE - czy mamy dalej procesowac</param>
        /// <param name="ProgressEventFunction">Funkcja ktora przyjmuje obiekt BO aktualnie procesowany, jaki jest jego indeks, ilosc wszystkich obiektow, czy sie powiodlo API, i zwraca TRUE/FALSE czy przerwac orepacje</param>
        /// <param name="EndEventFunction"></param>
        public void APISyncAll(Func<int, bool> StartEventFunction, Func<PI.FM.N000.Base.BL.BO.Base, int, bool, string, bool> ProgressEventFunction, Func<bool> EndEventFunction)
        {
            //restorujemy kolecje - wszystkie dane
            List<BO.School> _listSchool = School.Restore();
            List<BO.Instructor> _listInstructor = Instructor.Restore();
            List<BO.Class> _listClass = Class.Restore();
            List<BO.Student> _listStudent = Student.Restore();

            int _totalCount = _listSchool.Count + _listInstructor.Count + _listClass.Count + _listStudent.Count;
            if (StartEventFunction != null)
            {
                if (!StartEventFunction(_totalCount))
                {
                    return;
                }
            }

            bool _cancel = false;
            int _index = 0;
            Gemini.Core.BL.Base.MethodResult _MethodResult = null;
            PI.FM.N001.Account.BL.BO.User _user = null;
            // szkoly
            foreach (BO.School _loopSchool in _listSchool)
            {
                _MethodResult = APIEduFarma.SyncSchoolSave(_loopSchool);
                if (ProgressEventFunction != null)
                {
                    if (!ProgressEventFunction(_loopSchool, _index, _MethodResult.Success, _MethodResult.GetAllText()))
                    {
                        _cancel = true;
                        break;
                    }
                }
                _index++;
            }

            if (!_cancel)
            {
                // nauczyciele
                _index = 0;
                foreach (BO.Instructor _loopInstructor in _listInstructor)
                {
                    _user = RBL.Account.User.RestoreByID(_loopInstructor.UserID);
                    if (_user != null)
                    {
                        _loopInstructor.TmpPassword = _user.Password;
                        _MethodResult = APIEduFarma.SyncInstructorSave(_loopInstructor);
                        if (ProgressEventFunction != null)
                        {
                            if (!ProgressEventFunction(_loopInstructor, _index, _MethodResult.Success, _MethodResult.GetAllText()))
                            {
                                _cancel = true;
                                break;
                            }
                        }
                    }
                    _index++;
                }
            }

            if (!_cancel)
            {
                // klasy
                _index = 0;
                foreach (BO.Class _loopClass in _listClass)
                {
                    _MethodResult = APIEduFarma.SyncClassSave(_loopClass);
                    if (ProgressEventFunction != null)
                    {
                        if (!ProgressEventFunction(_loopClass, _index, _MethodResult.Success, _MethodResult.GetAllText()))
                        {
                            _cancel = true;
                            break;
                        }
                    }
                    _index++;
                }
            }

            if (!_cancel)
            {
                // uczniowie
                _index = 0;
                foreach (BO.Student _loopStudent in _listStudent)
                {
                    _user = RBL.Account.User.RestoreByID(_loopStudent.UserID);
                    if (_user != null)
                    {
                        _loopStudent.TmpPassword = _user.Password;
                        _MethodResult = APIEduFarma.SyncStudentSave(_loopStudent);
                        if (ProgressEventFunction != null)
                        {
                            if (!ProgressEventFunction(_loopStudent, _index, _MethodResult.Success, _MethodResult.GetAllText()))
                            {
                                _cancel = true;
                                break;
                            }
                        }
                    }
                    _index++;
                }
            }

            // koniec
            if (EndEventFunction != null)
            {
                EndEventFunction();
            }
        }


    }
}